import java.io.*;
import java.util.*;
import java.math.*;

public class B implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	private void solve() throws IOException {
		int n = nextInt();
		int totalVertices = 2 * n;
		List<Integer>[] edges = new List[totalVertices];
		List<Integer>[] reverseEdges = new List[totalVertices];
		for (int i = 0; i < totalVertices; i++) {
			edges[i] = new ArrayList<>();
			reverseEdges[i] = new ArrayList<>();
		}
		boolean[][] can = new boolean[n][totalVertices];
		for (int i = 0; i < n; i++) {
			int m = nextInt();
			for (int j = 0; j < m; j++) {
				int v = nextInt() - 1;
				v += n;
				edges[v].add(i);
				reverseEdges[i].add(v);
				can[i][v] = true;
			}
		}
		int[] initEdge = new int[n];
		for (int i = 0; i < n; i++) {
			int v = nextInt() - 1;
			v += n;
			initEdge[i] = v;
			edges[i].add(v);
			reverseEdges[v].add(i);
		}
		List<Integer> topSort = new ArrayList<>();
		boolean[] used = new boolean[totalVertices];
		for (int i = 0; i < totalVertices; i++) {
			if (!used[i]) {
				dfs(i, used, edges, topSort);
			}
		}
		Collections.reverse(topSort);
		int[] strongIds = new int[totalVertices];
		Arrays.fill(used, false);
		int lastStrongId = 0;
		for (int i = 0; i < totalVertices; i++) {
			int u = topSort.get(i);
			if (!used[u]) {
				dfsRev(u, used, reverseEdges, strongIds, lastStrongId++);
			}
		}
		for (int i = 0; i < n; i++) {
			int cnt = 0;
			for (int j = 0; j < n; j++) {
				if (strongIds[initEdge[i]] == strongIds[j + n] && can[i][j + n]) {
					++cnt;
				}
			}
			out.print(cnt);
			for (int j = 0; j < n; j++) {
				if (strongIds[initEdge[i]] == strongIds[j + n] && can[i][j + n]) {
					out.print(' ');
					out.print(j + 1);
				}
			}
			out.println();
		}
	}

	private void dfsRev(int u, boolean[] used, List<Integer>[] edges,
			int[] strongIds, int strongId) {
		used[u] = true;
		strongIds[u] = strongId;
		for (int v : edges[u]) {
			if (!used[v]) {
				dfsRev(v, used, edges, strongIds, strongId);
			}
		}
	}

	private void dfs(int u, boolean[] used, List<Integer>[] edges,
			List<Integer> topSort) {
		used[u] = true;
		for (int v : edges[u]) {
			if (!used[v]) {
				dfs(v, used, edges, topSort);
			}
		}
		topSort.add(u);
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new B().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
